var WeFollow = {
    init: function() {
        WeFollow.bindButtons();

        $('.go').click(function() {
            var location = '/twitter/' + this.form.enter_category.value.replace('#', '');
            window.location = location;
            return false;
        });

/*
        $('.autocomplete').each(function() {
            var foo = $(this).parent().children('div').show().get(0);
            alert(findPosX(foo));
        });
        */
    },
    unBindButtons: function() {
        $('.a-info').unbind().click(function() {
            return false;
        });
    },
    bindButtons: function() {
        $('.a-info').click(function() {
            WeFollow.unBindButtons();
            $('.more-info:not(#info-' + this.id + ')').hide('fast');
            $('#info-' + this.id).toggle('fast', WeFollow.bindButtons);
            return false;
        });

        $('.autocomplete').blur(function() {
            // hide drop downs
            // check if change... if not revert clear
            if (this.value == '') {
                $(this).siblings('div').hide();
            }
        });

        $('.autocomplete').click(function() {
            var id = $(this).siblings('div').attr('id');
            $('.autocomplete').each(function() {
                if ($(this).siblings('div').attr('id') != id) {
                    $(this).siblings('div').hide();
                }
            });
        });

        $('.autocomplete').keyup(function(e) {
            if (e.keyCode != 8 && (e.keyCode < 65 || e.keyCode > 90)) {
                return;
            }
            var value = this.value;
            setTimeout('WeFollow.autoComplete(\'' + this.id + '\', \'' + value + '\')', 150);
        });

        $('.autocomplete').keydown(function(e) {
            switch (e.keyCode) {
                case 9:
                case 40:
                    WeFollow.autoCompleteScroll(this, true);
                    return false;
                    break;
                case 38:
                    WeFollow.autoCompleteScroll(this, false);
                    return false;
                    break;
                case 13:
                    $(this).siblings('div').children('ul').children('li').each(function() {
                        if ($(this).hasClass('selected')) {
                            WeFollow.autoCompleteSelect(this);
                            return false;
                        }
                    });

                    if (this.id == 'big-ass-search') {
                        var location = '/twitter/' + this.value;
                        window.location = location;
                    }
                    return false;
                    break;
            }
        });
    },
    autoComplete: function(id, value) {
        var el = $('#' + id).siblings('div');
        if ($('#' + id).val().length < 1) {
            el.hide();
            el.html('');
            return;
        }

        if (value != $('#' + id).val()) {
            return;
        }

        var url = '/autocomplete.json?term=';
        $.ajax({
            type: 'GET',
            url:  url + value,
            dataType: 'JSON',
            success: function(json) {
                json = eval(json);
                if (json.length < 1) {
                    el.hide();
                    return;
                }
                var ul = $('<ul>');
                $.each(json, function(i, value) {
                    var li = $('<li><a>' + value.name + '</a> (' + value.users + ')</li>');
                    ul.append(li);
                });

                $(el).html('<ul>' + ul.html() + '</ul>');
                $(el).children('ul').children('li').click(function() {
                    WeFollow.autoCompleteSelect(this);
                   return false;
                });

                $(el).show();
            }
        });
    },
    autoCompleteSelect: function(el) {
        if (el != null && undefined != el.keyCode) {
            el = this;
        }

        var input = $(el).closest('div').siblings('input');
        input.val($(el).children('a').text());

        if (input.attr('id') == 'big-ass-search') {
            var location = '/twitter/' + $(el).children('a').text();
            window.location = location;
        } else {
            input.siblings('div').hide();
        }

        return false;
    },
    autoCompleteScroll: function(el, down) {
        var li = $(el).siblings('div').children('ul').children('li');
        if (li.hasClass('selected') == false) {
            li.eq(0).addClass('selected');
            return;
        }

        li.each(function() {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                if (down) {
                    $(this).next().addClass('selected');
                } else {
                    $(this).prev().addClass('selected');
                }

                return false;
            }
        });

    }
};


$(document).ready(function() {
    WeFollow.init();
    var welcomed = $.cookie('welcomed');
    if (welcomed == null || welcomed == 0) {
        $('#welcome').show();
        $('#welcome-window').show();
    }

    $('.close-window').click(function() {
        $('#welcome').hide();
        $('#welcome-window').hide();
        return false;
    });

    $('#welcome-window > a').click(function() {
        $.cookie('welcomed', 1, { });
    });
});

function findPosX(obj)
  {
    var curleft = 0;
    if(obj.offsetParent)
        while(1) 
        {
          curleft += obj.offsetLeft;
          if(!obj.offsetParent)
            break;
          obj = obj.offsetParent;
        }
    else if(obj.x)
        curleft += obj.x;
    return curleft;
  }

  function findPosY(obj)
  {
    var curtop = 0;
    if(obj.offsetParent)
        while(1)
        {
          curtop += obj.offsetTop;
          if(!obj.offsetParent)
            break;
          obj = obj.offsetParent;
        }
    else if(obj.y)
        curtop += obj.y;
    return curtop;
  }